//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fLsystem1.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int y0 = 50, dlg = 30;
 formula = "A";             //inicjowanie formuy

 POZYCJA = 0;               //inicjowanie algorytmu rysuj()
 rysuj( 100, y0, 90, dlg);

 rozwin();
 POZYCJA = 0;
 rysuj( 250, y0, 90, dlg);

 rozwin();
 POZYCJA = 0;
 rysuj( 400, y0, 90, dlg);
 Caption = formula;
}
//---------------------------------------------------------------------------
//  Wzrost roliny
void TForm1 :: rozwin( void)
{
 String tmp;
 int i, dlg = formula.Length();
 char c;

 for( i = 1; i <= dlg; i ++)
 {
    c = formula[ i];
    switch( c)
    {
     case 'A':              //gazka typu A
                tmp += "B(A)B(A)A";
                break;
     case 'B':              //gazka typu B
                tmp += "BB";
                break;
     case '(':              //boczny odrost
                tmp += "(";
                break;
     case ')':              //koniec odrostu
                tmp += ")";
                break;
    }
 }
 formula = tmp;
}
//---------------------------------------------------------------------------
//  Interpretuj formu, poczwszy od pozycji POZYCJA.
//  Uwaga: bywa, e ta funkcja wywouje sam siebie.
//  Wtedy kluczowe znaczenie ma zewntrzna zmienna POZYCJA ...
void TForm1 :: rysuj( double x0, double y0, double kat, double dlg)
{
 int len = formula.Length();
 char c;
 double dkat = 45;              //modyfikacja kta odrostu
 double k = M_PI / 180.;        //stopnie na radiany

 Canvas -> Pen -> Width = 2;
 while( POZYCJA < len)
 {
    c = formula[ ++POZYCJA];
    switch( c)
    {
     case 'A':                  //wykrel odcinek biay
                Canvas -> Pen -> Color = clWhite;
                Canvas -> MoveTo( x0, ClientHeight-y0);
                x0 += dlg * cos( k * kat);
                y0 += dlg * sin( k * kat);
                Canvas -> LineTo( x0, ClientHeight-y0);
                break;
     case 'B':                  //wykrel odcinek czarny
                Canvas -> Pen -> Color = clBlack;
                Canvas -> MoveTo( x0, ClientHeight-y0);
                x0 += dlg * cos( k * kat);
                y0 += dlg * sin( k * kat);
                Canvas -> LineTo( x0, ClientHeight-y0);
                break;
     case '(':                  //odrost
                dkat = -dkat;   //raz w lewo, raz w prawo ...
                rysuj( x0, y0, kat + dkat, dlg);
                break;
     case ')':                  //koniec odrostu
                return;     
    }
 }
 return;
}
//---------------------------------------------------------------------------

